#ifdef __APPLE__
#include <GLUT/glut.h> // for Mac
#else
#include <GL/glut.h> // for PC
#endif

GLfloat vertex[][3] = {
  { 0.0f, 0.0f, 0.0f },
  { 1.0f, 0.0f, 0.0f },
  { 1.0f, 1.0f, 0.0f },
  { 0.0f, 1.0f, 0.0f },
  { 0.0f, 0.0f, 1.0f },
  { 1.0f, 0.0f, 1.0f },
  { 1.0f, 1.0f, 1.0f },
  { 0.0f, 1.0f, 1.0f }
};

int edge[][2] = {
  { 0, 1 },
  { 1, 2 },
  { 2, 3 },
  { 3, 0 },
  { 4, 5 },
  { 5, 6 },
  { 6, 7 },
  { 7, 4 },
  { 0, 4 },
  { 1, 5 },
  { 2, 6 },
  { 3, 7 }
};

float g_r = 0.0f;

void
display(void)
{
  int i;

  glClear(GL_COLOR_BUFFER_BIT);
  glColor3f(0.0f, 0.0f, 0.0f);
  glLoadIdentity();
  gluLookAt(3.0, 4.0, 5.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
  glRotatef(g_r, 0.0f, 1.0f, 0.0f);
  glBegin(GL_LINES);
  for (i = 0; i < 12; ++i) {
    glVertex3fv(vertex[edge[i][0]]);
    glVertex3fv(vertex[edge[i][1]]);
  }
  glEnd();
  //glFlush();
  glutSwapBuffers();
}

void
resize(int w, int h)
{
  glViewport(0, 0, w, h);
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluPerspective(30.0, (double)w/(double)h, 1.0f, 100.0f);
  //glTranslatef(0.0f, 0.0f, -5.0f);
  glMatrixMode(GL_MODELVIEW);
  //gluLookAt(3.0, 4.0, 5.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
}

void
init(void)
{
  glClearColor(1.0, 1.0, 1.0, 0.0);
  //glClearColor(0.0, 0.0, 0.0, 0.0);
}

void
idle(void)
{
  g_r = g_r + 10.0f;
  if (g_r >= 360.0f) {
    g_r = 0.0f;
  }
  glutPostRedisplay();
  usleep(50000);
}

int
main(int ac, char **av)
{
  glutInit(&ac, av);
  glutInitDisplayMode(GLUT_RGBA | GLUT_DOUBLE);
  glutCreateWindow(av[0]);
  glutDisplayFunc(display);
  glutReshapeFunc(resize);
  glutIdleFunc(idle);
  init();
  glutMainLoop();
  return 0;
}
