#ifdef __APPLE__
#include <GLUT/glut.h> // for Mac
#else
#include <GL/glut.h> // for PC
#endif

float g_r = 0.0f;

void
display(void)
{
  int i;
  float red[] = {1.0f, 0.0f, 0.0f, 1.0f};
  float green[] = {0.0f, 1.0f, 0.0f, 1.0f};

  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  glLoadIdentity();
  glEnable(GL_DEPTH_TEST);
  //gluLookAt(0.0, 0.0, 10.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
  gluLookAt(0.0, 0.0, 50.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
  //gluLookAt(0.0, 50.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
  
  glRotatef(g_r, 0.0f, 1.0f, 0.0f);

  glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, red);
  glutSolidTetrahedron();

  glTranslatef(0.0, 0.0, 10.0f);

  //glRotatef(g_r * 2.0f, 0.0f, 1.0f, 0.0f);
  glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, green);
  glutSolidTeapot(1.0f);

  glutSwapBuffers();
}

void
resize(int w, int h)
{
  glViewport(0, 0, w, h);
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluPerspective(30.0, (double)w/(double)h, 1.0f, 100.0f);
  //glTranslatef(0.0f, 0.0f, -5.0f);
  glMatrixMode(GL_MODELVIEW);
  //gluLookAt(3.0, 4.0, 5.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
}

void
init(void)
{
  //glClearColor(1.0, 1.0, 1.0, 0.0);
  glClearColor(0.0, 0.0, 0.0, 0.0);

  glEnable(GL_LIGHTING);
  glEnable(GL_LIGHT0);
}

void
idle(void)
{
  g_r = g_r + 10.0f;
  //g_r = g_r + 2.0f;

  if (g_r >= 360.0f) {
    g_r = 0.0f;
  }
  glutPostRedisplay();
  usleep(50000);
}

int
main(int ac, char **av)
{
  glutInit(&ac, av);
  glutInitDisplayMode(GLUT_RGBA | GLUT_DEPTH | GLUT_DOUBLE);
  glutCreateWindow(av[0]);
  glutDisplayFunc(display);
  glutReshapeFunc(resize);
  glutIdleFunc(idle);
  init();
  glutMainLoop();
  return 0;
}
