// gltest18.c

#ifdef __APPLE__
#include <GLUT/glut.h> // for Mac
#else
#include <GL/glut.h> // for PC
#endif

#include <stdio.h>
#include <stdlib.h>

#include "pbmload.h"

float g_r = 0.0f;

void
display(void)
{
  int i;

  glClear(GL_COLOR_BUFFER_BIT);
  glColor3f(1.0f, 1.0f, 1.0f);
  glLoadIdentity();
  glTranslatef(0.0, 0.0, -5.0f);
  glRotatef(g_r, 0.0f, 1.0f, 0.0f);

  glEnable(GL_TEXTURE_2D);

  glBegin(GL_POLYGON);
  glTexCoord2d(0.0, 16.0);
  glVertex3f(-8.0f, -8.0f, 0.0f);
  glTexCoord2d(16.0, 16.0);
  glVertex3f( 8.0f, -8.0f, 0.0f);
  glTexCoord2d(16.0, 0.0);
  glVertex3f( 8.0f,  8.0f, 0.0f);
  glTexCoord2d(0.0, 0.0);
  glVertex3f(-8.0f,  8.0f, 0.0f);
  glEnd();

  glutSwapBuffers();
}

void
resize(int w, int h)
{
  glViewport(0, 0, w, h);
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluPerspective(30.0, (double)w/(double)h, 1.0f, 100.0f);
  //glTranslatef(0.0f, 0.0f, -5.0f);
  //gluLookAt(0.0, 0.0, 5.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
  glMatrixMode(GL_MODELVIEW);
}

void
init(void)
{
  char *texture;
  int width, height;

  glClearColor(0.0, 0.0, 0.0, 0.0);

  glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
  
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);

  texture = pbm_load("asukayama256.pbm", &width, &height);

  glTexImage2D(GL_TEXTURE_2D, 0, GL_RGB, width, height, 0,
	       GL_RGB, GL_UNSIGNED_BYTE, texture);

  pbm_free(texture);
}

void
idle(void)
{
  g_r = g_r + 10.0f;
  if (g_r >= 360.0f) {
    g_r = 0.0f;
  }
  glutPostRedisplay();
  usleep(50000);
}

void
keyboard(unsigned char key, int x, int y)
{
  switch (key) {
  case 'q':
    exit(1);
    break;
  case ' ':
    glutIdleFunc(0);
    break;
  case '\r':
    glutIdleFunc(idle);
    break;
  default:
    printf("key: %d\n", key);
    break;
  }
}

int
main(int ac, char **av)
{
  glutInit(&ac, av);
  glutInitDisplayMode(GLUT_RGBA | GLUT_DOUBLE);
  glutCreateWindow(av[0]);
  glutDisplayFunc(display);
  glutReshapeFunc(resize);
  glutIdleFunc(idle);
  glutKeyboardFunc(keyboard);
  init();
  glutMainLoop();
  return 0;
}
