// gltest16.c (<- gltest3.c)

#ifdef __APPLE__
#include <GLUT/glut.h> // for Mac
#else
#include <GL/glut.h> // for PC
#endif

float g_r = 0.0f;

void
display(void)
{
  int i;

  glClear(GL_COLOR_BUFFER_BIT);
  glColor3f(1.0f, 1.0f, 1.0f);
  glLoadIdentity();
  glTranslatef(0.0, 0.0, -5.0f);
  glRotatef(g_r, 0.0f, 1.0f, 0.0f);

  glBegin(GL_POLYGON);
  glVertex3f(-1.0f, -1.0f, 0.0f);
  glVertex3f( 1.0f, -1.0f, 0.0f);
  glVertex3f( 1.0f,  1.0f, 0.0f);
  glVertex3f(-1.0f,  1.0f, 0.0f);
  glEnd();

  glutSwapBuffers();
}

void
resize(int w, int h)
{
  glViewport(0, 0, w, h);
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluPerspective(30.0, (double)w/(double)h, 1.0f, 100.0f);
  //glTranslatef(0.0f, 0.0f, -5.0f);
  //gluLookAt(0.0, 0.0, 5.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
  glMatrixMode(GL_MODELVIEW);
}

void
init(void)
{
  glClearColor(0.0, 0.0, 0.0, 0.0);
}

void
idle(void)
{
  g_r = g_r + 10.0f;
  if (g_r >= 360.0f) {
    g_r = 0.0f;
  }
  glutPostRedisplay();
  usleep(50000);
}

int
main(int ac, char **av)
{
  glutInit(&ac, av);
  glutInitDisplayMode(GLUT_RGBA | GLUT_DOUBLE);
  glutCreateWindow(av[0]);
  glutDisplayFunc(display);
  glutReshapeFunc(resize);
  glutIdleFunc(idle);
  init();
  glutMainLoop();
  return 0;
}
