// pbmload.c

// load ppm file. (In Photoshop, ppm called pbm)

#include <stdio.h>
#include <stdlib.h>
#include "pbmload.h"

#define MYBUFSIZE 4096

char *
pbm_load(char *fn, int *width, int *height)
{
  FILE *fp;
  char buf[MYBUFSIZE];
  int retval;
  int dummy;
  char *retbuf, *bufptr;
  int readsize, size;

  if (NULL == (fp = fopen(fn, "r"))) {
    perror(fn);
    exit(1);
  }

  if (NULL == fgets(buf, MYBUFSIZE, fp)) {
    fprintf(stderr, "ERROR: short file '%s'\n", fn);
    exit(1);
  }

  if (NULL == fgets(buf, MYBUFSIZE, fp)) {
    fprintf(stderr, "ERROR: short file '%s'\n", fn);
    exit(1);
  }

  retval = sscanf(buf, "%d %d %d", width, height, &dummy);

  if (retval < 3) {
    if (NULL == fgets(buf, MYBUFSIZE, fp)) {
      fprintf(stderr, "ERROR: short file '%s'\n", fn);
      exit(1);
    }

    switch (retval) {
    case 1:
      retval = sscanf(buf, "%d %d", height, &dummy);
      if (NULL == fgets(buf, MYBUFSIZE, fp)) {
	fprintf(stderr, "ERROR: short file '%s'\n", fn);
	exit(1);
      }
      //retval = sscanf(buf, "%d", &dummy);
      break;
    case 2:
      //retval = sscanf(buf, "%d", &dummy);
      break;
    }
  }

  size = *width * *height * 3;
  
  if (NULL == (retbuf = malloc(size))) {
    perror("malloc()");
    exit(1);
  }

  bufptr = retbuf;

  retval = fread(bufptr, 1, size, fp);

  if (size != retval) {
    fprintf(stderr, "ERROR: short file '%s'\n", fn);
    exit(1);
  }

  fclose(fp);
  return retbuf;
}

void
pbm_free(char *buf)
{
  free(buf);
}
