// gltest15.c

#ifdef __APPLE__
#include <GLUT/glut.h> // for Mac
#else
#include <GL/glut.h> // for PC
#endif
#include <math.h>

float g_r = 0.0f;
float g_r2 = 0.0f;

GLfloat light0pos[] = {0.0f, 0.0f, 10.0f, 1.0f};
GLfloat white[] = {0.8f, 0.8f, 0.8f, 1.0f};
GLfloat red[] = {0.8f, 0.0f, 0.0f, 1.0f};
GLfloat green[] = {0.0f, 0.8f, 0.0f, 1.0f};
GLfloat blue[] = {0.0f, 0.0f, 0.8f, 1.0f};
GLfloat yellow[] = {0.8f, 0.8f, 0.0f, 1.0f};
GLfloat yellow2[] = {0.1f, 0.1f, 0.0f, 1.0f};

void
vec_cross_product(float ret[3], float a[3], float b[3])
{
  float x, y, z, len;

  x = a[1]*b[2] - a[2]*b[1];
  y = a[2]*b[0] - a[0]*b[2];
  z = a[0]*b[1] - a[1]*b[0];
  
  len = (float)sqrt(x * x + y * y + z * z);

  ret[0] = x / len;
  ret[1] = y / len;
  ret[2] = z / len;
}

void
vec_subtract(float ret[3], float a[3], float b[3])
{
  ret[0] = a[0] - b[0];
  ret[1] = a[1] - b[1];
  ret[2] = a[2] - b[2];
}

float p1[] = {1.0f, -.5f, 1.0f},
  p2[] = {0.0f, 1.0f, 0.0f},
  p3[] = {-1.0f, -.5f, 0.0f},
  p4[] = {1.0f, -.5f, -1.0f};

void
display(void)
{
  int i;
  float norm[3], v1[3], v2[3];

  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  glLoadIdentity();
  glEnable(GL_DEPTH_TEST);
  gluLookAt(0.0, 0.0, 10.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
  //gluLookAt(0.0, 50.0, -10.0, 0.0, 0.0, -10.0, 0.0, 0.0, 1.0);

  glLightfv(GL_LIGHT0, GL_POSITION, light0pos);

  //glTranslatef(0.0, 0.0, -10.0f);
  glRotatef(g_r, 0.0f, 1.0f, 0.0f);

  //glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, red);
  //glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT, yellow);
  //glMaterialf(GL_FRONT_AND_BACK, GL_SHININESS, 30.0f);
  //glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, yellow);
  //glMaterialfv(GL_FRONT_AND_BACK, GL_EMISSION, yellow);

  glBegin(GL_TRIANGLES);

  // face 1
  //glColor3f(1.0f, 1.0f, 1.0f); // White
  glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, white);
  vec_subtract(v1, p2, p1);
  vec_subtract(v2, p3, p1);
  vec_cross_product(norm, v1, v2);
  glNormal3fv(norm);
  glVertex3fv(p1);
  glNormal3fv(norm);
  glVertex3fv(p2);
  glNormal3fv(norm);
  glVertex3fv(p3);

  // face 2
  //glColor3f(1.0f, 0.0f, 0.0f); // Red
  glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, red);
  vec_subtract(v1, p2, p3);
  vec_subtract(v2, p4, p3);
  vec_cross_product(norm, v1, v2);
  glNormal3fv(norm);
  glVertex3fv(p3); // -1.0f, -.5f, 0.0f);
  glNormal3fv(norm);
  glVertex3fv(p2); // 0.0f, 1.0f, 0.0f);
  glNormal3fv(norm);
  glVertex3fv(p4); // 1.0f, -.5f, -1.0f);

  // face 3
  //glColor3f(0.0f, 1.0f, 0.0f); // Green
  glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, green);
  vec_subtract(v1, p2, p4);
  vec_subtract(v2, p1, p4);
  vec_cross_product(norm, v1, v2);
  glNormal3fv(norm);
  glVertex3fv(p4); // 1.0f, -.5f, -1.0f);
  glNormal3fv(norm);
  glVertex3fv(p2); // 0.0f, 1.0f, 0.0f);
  glNormal3fv(norm);
  glVertex3fv(p1); // 1.0f, -.5f, 1.0f);

  glEnd();


  glutSwapBuffers();
}

void
resize(int w, int h)
{
  glViewport(0, 0, w, h);
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluPerspective(30.0, (double)w/(double)h, 1.0f, 100.0f);
  //glTranslatef(0.0f, 0.0f, -5.0f);
  glMatrixMode(GL_MODELVIEW);
  //gluLookAt(3.0, 4.0, 5.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
}

void
init(void)
{
  //glClearColor(1.0, 1.0, 1.0, 0.0);
  glClearColor(0.0, 0.0, 0.0, 0.0);

  glEnable(GL_LIGHTING);
  glEnable(GL_LIGHT0);
}

void
idle(void)
{
  g_r = g_r + 10.0f;
  g_r2 = g_r2 + 15.0f;

  if (g_r >= 360.0f) {
    g_r = g_r - 360.0f;
  }

  if (g_r2 >= 360.0f) {
    g_r2 = g_r2 - 360.0f;
  }

  glutPostRedisplay();
  usleep(50000);
}

int
main(int ac, char **av)
{
  glutInit(&ac, av);
  glutInitDisplayMode(GLUT_RGBA | GLUT_DEPTH | GLUT_DOUBLE);
  glutCreateWindow(av[0]);
  glutDisplayFunc(display);
  glutReshapeFunc(resize);
  glutIdleFunc(idle);
  init();
  glutMainLoop();
  return 0;
}
